#include "RobotControllerAgent.h"
#include "GlobalVisionRobotControllerFilter.h"
#include "../DataTypes/DataRobotControllerAgent.h"
#include "FilterFactory.h"
#include <iostream>
namespace Communication
{

RobotControllerAgent::RobotControllerAgent()
{
	this->agentkey = "RobotController";
	this->filter = FilterFactory::GetInstance()->GetGlobalVisionRobotFilter();
}

RobotControllerAgent::RobotControllerAgent(int port, string ip, bool syncmode, double broadcastint, list<int> robotids, string key)
{
	this->port= port;
	this->ip= ip;
	this->syncmode= syncmode;
	this->agentkey = key;
	this->filter = FilterFactory::GetInstance()->GetGlobalVisionRobotFilter();
	this->robotIds = robotids;
	this->broadcastinterval = broadcastint;
	this->syncflag = false;
}

RobotControllerAgent::~RobotControllerAgent()
{
}

int RobotControllerAgent::GetPort()
{
	return this->port;
}

string RobotControllerAgent::GetIP()
{
	return this->ip;
}

bool RobotControllerAgent::GetSyncMode()
{
	return this->syncmode;
}

bool RobotControllerAgent::GetSyncFlag()
{
	return this->syncflag;
}

int RobotControllerAgent::GetIterationSync()
{
	return this->iterationsync;
}

string RobotControllerAgent::GetKey()
{
	return this->agentkey;
}

list <int> RobotControllerAgent::GetRobotIds()
{
	return robotIds;
}

void RobotControllerAgent::SetPort(int port)
{
	this->port = port;
}
void RobotControllerAgent::SetIP(string ip)
{
	this->ip = ip;
}
void RobotControllerAgent::SetKey(string key)
{
	this->agentkey = key;
}

void RobotControllerAgent::SetSyncMode(bool syncmode)
{
	this->syncmode = syncmode;
}

void RobotControllerAgent::SetRobotIds(std::list <int> robotids)
{
	this->robotIds = robotids;
}

string RobotControllerAgent::FilterData(string data)
{
	return this->filter->FilterData(data);
}

DataAgent* RobotControllerAgent::GetDataAgent()
{
	return new DataRobotControllerAgent(port, ip, broadcastinterval, syncmode, robotIds,agentkey);
}

double RobotControllerAgent::GetTimeStamp()
{
	return timestamp;
}

void RobotControllerAgent::SetTimeStamp(double value)
{
	this->timestamp = value;
}

double RobotControllerAgent::GetBroadcastInterval()
{
	return broadcastinterval;
}

void RobotControllerAgent::SetBroadcastInterval(double value)
{
	this->broadcastinterval = value;
}

void RobotControllerAgent::SetSyncFlag(bool value)
{
	this->syncflag = value;
}

void RobotControllerAgent::SetIterationSync(int value)
{
	this->iterationsync = value;
}

}
